% file for iteration algorithm, optimzation problem P1
function [gamma_bar,K_Delta,N_bar,G_bar,L_bar,H_bar,P_bar] = Optimization_P2(A,B,F,D,C,Mc,Nc,K0,N,G,L,H,L1,beta,Q) 

[n,m] = size(B);
[~,q] = size(F);
[~,l] = size(D);
[p,~] = size(C);

Cx = eye(n);
Ce = eye(n+2*q);

% augmented system
A_bar = [A F zeros(n,q); zeros(q,n) zeros(q,q) eye(q); zeros(q,n) zeros(q,q) zeros(q,q)];
C_bar = [C zeros(p,q) zeros(p,q)];
D_bar = [D zeros(n,q); zeros(q,l) zeros(q,q); zeros(q,l) eye(q)];


D_tilde = [D zeros(n,q)];
Be_tilde = [zeros(n,n) F zeros(n,q)];
Mc_bar = [Mc; zeros(2*q,n)];


gamma = sdpvar(1,1);
P = sdpvar(n,n);
M = sdpvar(m,n);

X = Q*H;
Y = Q*L1;

beta1 = beta(1,1);
beta2 = beta(2,2);
beta3 = beta(3,3);
beta4 = beta(4,4);
beta5 = beta(5,5);

LMI1 = blkvar();
LMI1(1,1) = beta1*(A*P+B*(K0*P+M)) + beta1*(A*P+B*(K0*P+M))';
LMI1(1,2) = beta1*D_tilde;
LMI1(1,3) = beta1*Mc;
LMI1(1,4) = beta1*P*Nc';
LMI1(1,5) = beta1*P*Cx';

LMI1(1,6) = Be_tilde;
LMI1(1,7) = P*Nc';
LMI1(1,8) = zeros(n,n);
LMI1(1,9) = zeros(n,n+2*q);
LMI1(1,10) = -B*(K0*P+M);
LMI1(1,11) = zeros(n,n);

LMI1(2,2) = -beta2*gamma*eye(l+q);
LMI1(2,3) = beta2*zeros(l+q,n);
LMI1(2,4) = beta2*zeros(l+q,n);
LMI1(2,5) = beta2*zeros(l+q,n);

LMI1(2,6) = ((Q-X*C_bar)*D_bar)';
LMI1(2,7) = zeros(l+q,n);
LMI1(2,8) = zeros(l+q,n);
LMI1(2,9) = zeros(l+q,n+2*q);
LMI1(2,10) = zeros(l+q,n);
LMI1(2,11) = zeros(l+q,n);

LMI1(3,3) = -beta3*eye(n);
LMI1(3,4) = beta3*zeros(n,n);
LMI1(3,5) = beta3*zeros(n,n);

LMI1(3,6) = zeros(n,n+2*q);
LMI1(3,7) = zeros(n,n);
LMI1(3,8) = zeros(n,n);
LMI1(3,9) = zeros(n,n+2*q);
LMI1(3,10) = zeros(n,n);
LMI1(3,11) = zeros(n,n);

LMI1(4,4) = -beta4*eye(n);
LMI1(4,5) = beta4*zeros(n,n);

LMI1(4,6) = zeros(n,n+2*q);
LMI1(4,7) = zeros(n,n);
LMI1(4,8) = zeros(n,n);
LMI1(4,9) = zeros(n,n+2*q);
LMI1(4,10) = zeros(n,n);
LMI1(4,11) = zeros(n,n);

LMI1(5,5) = -beta5*gamma*eye(n);

LMI1(5,6) = zeros(n,n+2*q);
LMI1(5,7) = zeros(n,n);
LMI1(5,8) = zeros(n,n);
LMI1(5,9) = zeros(n,n+2*q);
LMI1(5,10) = zeros(n,n);
LMI1(5,11) = eye(n);

LMI1(6,6) = ((Q-X*C_bar)*A_bar-Y*C_bar) + ((Q-X*C_bar)*A_bar-Y*C_bar)';
LMI1(6,7) = zeros(n+2*q,n);
LMI1(6,8) = (Q-X*C_bar)*Mc_bar;
LMI1(6,9) = Ce';
LMI1(6,10) = zeros(n+2*q,n);
LMI1(6,11) = zeros(n+2*q,n);

LMI1(7,7) = -eye(n);
LMI1(7,8) = zeros(n,n);
LMI1(7,9) = zeros(n,n+2*q);
LMI1(7,10) = zeros(n,n);
LMI1(7,11) = zeros(n,n);

LMI1(8,8) =-eye(n);
LMI1(8,9) = zeros(n,n+2*q);
LMI1(8,10) = zeros(n,n);
LMI1(8,11) = zeros(n,n);

LMI1(9,9) = -gamma*eye(n+2*q);
LMI1(9,10) = zeros(n+2*q,n);
LMI1(9,11) = zeros(n+2*q,n);

LMI1(10,10) = -P;
LMI1(10,11) = zeros(n,n);

LMI1(11,11) = -P;

LMI1 = sdpvar(LMI1);


obj = gamma;
const = [];
const = [const, gamma >= 0];
const = [const, P >= eps*eye(n)];
const = [const, LMI1 <= -eps*eye(10*n+5*q+l)];

ops = sdpsettings('solver','mosek','verbose',0);
optimize(const,obj,ops);

K_Delta =  value(M)*inv(value(P));

H_bar = H;
G_bar = G;
N_bar = N;
L_bar = L;
gamma_bar = value(gamma);
P_bar = value(P);

